import 'package:flutter/material.dart';
import 'package:admin_desktop/presentation/styles/style.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:intl/intl.dart';
import '../../../../../../domain/models/response/sale_history_response.dart';
import 'package:admin_desktop/infrastructure/services/utils.dart';
import 'package:admin_desktop/presentation/components/components.dart';

class SaleTab extends StatelessWidget {
  final List<SaleHistoryModel> list;
  final bool isLoading;
  final bool isMoreLoading;
  final bool hasMore;
  final VoidCallback viewMore;

  const SaleTab(
      {super.key,
      required this.list,
      required this.isLoading,
      required this.hasMore,
      required this.viewMore,
      required this.isMoreLoading});

  @override
  Widget build(BuildContext context) {
    return SingleChildScrollView(
            child: Column(
              children: [
                Container(
                  padding: const EdgeInsets.symmetric(vertical: 22),
                  decoration: BoxDecoration(
                      borderRadius: BorderRadius.circular(10), color: Style.white),
                  child: Table(
                    defaultColumnWidth: FixedColumnWidth(
                        (MediaQuery.sizeOf(context).width) / 6.5),
                    border: TableBorder.all(color: Style.transparent),
                    children: [
                      TableRow(
                        children: [
                          Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              Padding(
                                padding: const EdgeInsets.only(left: 16),
                                child: Text(
                                  AppHelpers.getTranslation(TrKeys.id),
                                  style: Style.interMedium(
                                    size: 16,
                                    color: Style.black,
                                    letterSpacing: -0.3,
                                  ),
                                ),
                              )
                            ],
                          ),
                          Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              Text(
                                AppHelpers.getTranslation(TrKeys.client),
                                style: Style.interMedium(
                                  size: 16,
                                  color: Style.black,
                                  letterSpacing: -0.3,
                                ),
                              )
                            ],
                          ),
                          Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              Text(
                                AppHelpers.getTranslation(TrKeys.amount),
                                style: Style.interMedium(
                                  size: 16,
                                  color: Style.black,
                                  letterSpacing: -0.3,
                                ),
                              )
                            ],
                          ),
                          Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              Text(
                                AppHelpers.getTranslation(TrKeys.paymentType),
                                style: Style.interMedium(
                                  size: 16,
                                  color: Style.black,
                                  letterSpacing: -0.3,
                                ),
                              )
                            ],
                          ),
                          Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              Text(
                                AppHelpers.getTranslation(TrKeys.note),
                                style: Style.interMedium(
                                  size: 16,
                                  color: Style.black,
                                  letterSpacing: -0.3,
                                ),
                              )
                            ],
                          ),
                          Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              Text(
                                AppHelpers.getTranslation(TrKeys.date),
                                style: Style.interMedium(
                                  size: 16,
                                  color: Style.black,
                                  letterSpacing: -0.3,
                                ),
                              )
                            ],
                          ),
                        ],
                      ),
                    ],
                  ),
                ),
                20.verticalSpace,
                list.isEmpty ? Column(
                  crossAxisAlignment: CrossAxisAlignment.center,
                  mainAxisAlignment: MainAxisAlignment.center,
                  children: [
                    70.verticalSpace,
                    Text(AppHelpers.getTranslation(TrKeys.empty),style: Style.interNormal(),),
                  ],
                ) :
                Container(
                  padding: const EdgeInsets.symmetric(vertical: 22),
                  decoration: BoxDecoration(
                      borderRadius: BorderRadius.circular(10), color: Style.white),
                  child: Table(
                    children: [
                      for (int i = 0; i < list.length; i++)
                        TableRow(
                          children: [
                            Padding(
                              padding: const EdgeInsets.symmetric(vertical: 12),
                              child: Column(
                                crossAxisAlignment: CrossAxisAlignment.start,
                                children: [
                                  const Divider(),
                                  Padding(
                                    padding: const EdgeInsets.only(left: 16),
                                    child: Text(
                                      "#${AppHelpers.getTranslation(TrKeys.id)}${list[i].id}",
                                      style: Style.interNormal(
                                        size: 14,
                                        color: Style.iconColor,
                                        letterSpacing: -0.3,
                                      ),
                                    ),
                                  ),
                                ],
                              ),
                            ),
                            Padding(
                              padding: const EdgeInsets.symmetric(vertical: 12),
                              child: Column(
                                crossAxisAlignment: CrossAxisAlignment.start,
                                children: [
                                  const Divider(),
                                  Text(
                                    "${list[i].user?.firstname ?? ""} ${list[i].user?.lastname ?? ""}",
                                    style: Style.interNormal(
                                      size: 14,
                                      color: Style.iconColor,
                                      letterSpacing: -0.3,
                                    ),
                                    maxLines: 1,
                                  )
                                ],
                              ),
                            ),
                            Padding(
                              padding: const EdgeInsets.symmetric(vertical: 12),
                              child: Column(
                                crossAxisAlignment: CrossAxisAlignment.start,
                                children: [
                                  const Divider(),
                                  Text(
                                    AppHelpers.numberFormat(
                                        number: list[i].totalPrice),
                                    style: Style.interNormal(
                                      size: 14,
                                      color: Style.iconColor,
                                      letterSpacing: -0.3,
                                    ),
                                  )
                                ],
                              ),
                            ),
                            Padding(
                              padding: const EdgeInsets.symmetric(vertical: 12),
                              child: Column(
                                crossAxisAlignment: CrossAxisAlignment.start,
                                children: [
                                  const Divider(),
                                  Text(
                                    (list[i].transactions?.isNotEmpty ?? false)
                                        ? list[i]
                                        .transactions
                                        ?.first
                                        .paymentSystem
                                        ?.tag ??
                                        ""
                                        : AppHelpers.getTranslation(TrKeys.na),
                                    style: Style.interNormal(
                                      size: 14,
                                      color: Style.iconColor,
                                      letterSpacing: -0.3,
                                    ),
                                  )
                                ],
                              ),
                            ),
                            Padding(
                              padding: const EdgeInsets.symmetric(vertical: 12),
                              child: Column(
                                crossAxisAlignment: CrossAxisAlignment.start,
                                children: [
                                  const Divider(),
                                  Text(
                                    list[i].note ??
                                        AppHelpers.getTranslation(TrKeys.na),
                                    style: Style.interNormal(
                                      size: 14,
                                      color: Style.iconColor,
                                      letterSpacing: -0.3,
                                    ),
                                  )
                                ],
                              ),
                            ),
                            Padding(
                              padding: const EdgeInsets.symmetric(vertical: 12),
                              child: Column(
                                crossAxisAlignment: CrossAxisAlignment.start,
                                children: [
                                  const Divider(),
                                  Text(
                                    DateFormat('d MMM yyyy').format(
                                        list[i].createdAt ?? DateTime.now()),
                                    style: Style.interNormal(
                                      size: 14,
                                      color: Style.iconColor,
                                      letterSpacing: -0.3,
                                    ),
                                  )
                                ],
                              ),
                            ),
                          ],
                        ),
                    ],
                  ),
                ),
                isLoading ? SizedBox.shrink() :
                isMoreLoading
                    ? const Padding(
                        padding: EdgeInsets.only(top: 18),
                        child: Center(
                            child: CircularProgressIndicator(
                          color: Style.black,
                        )),
                      )
                    :
                hasMore
                        ? InkWell(
                            borderRadius: BorderRadius.circular(10),
                            onTap: () {
                              viewMore.call();
                            },
                            child: ButtonEffectAnimation(
                              child: Container(
                                margin: const EdgeInsets.symmetric(
                                    horizontal: 64, vertical: 16),
                                height: 50,
                                decoration: BoxDecoration(
                                  borderRadius: BorderRadius.circular(10),
                                  border: Border.all(
                                    color: Style.black.withOpacity(0.17),
                                    width: 1,
                                  ),
                                ),
                                alignment: Alignment.center,
                                child: Text(
                                  AppHelpers.getTranslation(TrKeys.viewMore),
                                  style: Style.interNormal(
                                    size: 16,
                                    color: Style.black,
                                  ),
                                ),
                              ),
                            ),
                          )
                        : const SizedBox.shrink()
              ],
            ),
          );
  }
}
